/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.problem.DistributedProblemReplicator;
import java.util.HashSet;
import java.util.Set;

public class ProblemDataSyncThread
extends Thread {
    private static final String TRACE_MASKT = "XPAPDSTT";
    private static final String TRACE_MASKF = "XPAPDSTF";
    private static final String TRACE_MASKD = "XPAPDSTD";
    private DistributedAnalysisDomain domain = null;
    private Set targetSystems = null;
    private int problemDataSynchDelay = 0;

    public ProblemDataSyncThread(DistributedAnalysisDomain domain, Set targetSystems, int problemDataSynchDelay) {
        this.domain = domain;
        this.targetSystems = targetSystems;
        this.problemDataSynchDelay = problemDataSynchDelay;
        this.setName(this.getClass().getName() + " [" + domain.getDomainId().getDID() + "]");
    }

    public void run() {
        Trace.trace(TRACE_MASKD, "--> run (" + this.domain.getDomainId().getDID() + ")");
        if (this.problemDataSynchDelay > 0) {
            try {
                Thread.sleep(this.problemDataSynchDelay * 1000);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.targetSystems == null) {
            PASystem primarySys = this.domain.getPrimary();
            if (primarySys == null || primarySys instanceof ConsoleSystem) {
                this.targetSystems = this.domain.getParticipants();
                if (this.targetSystems.size() == 0) {
                    Trace.trace(TRACE_MASKD, "<-- run (no targets)");
                    return;
                }
            } else {
                this.targetSystems = new HashSet();
                this.targetSystems.add(primarySys);
            }
        }
        DistributedProblemReplicator.getDistributedProblemReplicator().synchronizeProblems(this.domain.getDomainId(), this.targetSystems);
        Trace.trace(TRACE_MASKD, "<-- run");
    }
}

